/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.init;

import dev.toma.gunsrpg.client.baked.SimpleBakedModel;
import dev.toma.gunsrpg.common.container.CrystalStationContainer;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import java.util.Map;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="gunsrpg", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistry {
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        SimpleBakedModel model = new SimpleBakedModel();
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof GunItem).map(item -> (GunItem)item).forEach(gun -> registry.put(ClientRegistry.getModelResourceLocation(gun), model));
        registry.put(ClientRegistry.getModelResourceLocation(ModItems.STASH_DETECTOR), model);
        registry.put(ClientRegistry.getModelResourceLocation(ModItems.SMG_TURRET), model);
        registry.put(ClientRegistry.getModelResourceLocation(ModItems.AR_TURRET), model);
        registry.put(ClientRegistry.getModelResourceLocation(ModItems.ROCKET_TURRET), model);
    }

    @SubscribeEvent
    public static void stitchTextures(TextureStitchEvent.Pre event) {
        AtlasTexture map = event.getMap();
        ResourceLocation mapPath = map.func_229223_g_();
        if (!mapPath.equals((Object)PlayerContainer.field_226615_c_)) {
            return;
        }
        event.addSprite(CrystalStationContainer.EMPTY_CRYSTAL_SLOT);
        event.addSprite(CrystalStationContainer.EMPTY_TRANSMUTATION_SLOT);
        event.addSprite(CrystalStationContainer.EMPTY_PURITY_SLOT);
    }

    protected static ModelResourceLocation getModelResourceLocation(Item item) {
        return new ModelResourceLocation(item.getRegistryName(), "inventory");
    }
}

